define(['angular', 'angularMocks', 'app', 'MainController', 'angularUiRouter', 'Modernizr'], function(angular, mocks, app) {
    'use strict';

    describe('The Main controller', function () {

        var controller,
            scope,
            q,
            pageServiceMock,
            globalDelayTrackerMock;

        beforeEach( function () {
            module('angularTemplateApp');

            globalDelayTrackerMock = jasmine.createSpyObj('globalDelayTracker', ['active']);
            module(function($provide){
                $provide.value('pageService', pageServiceMock);
                $provide.value('globalDelayTracker', globalDelayTrackerMock);
            });

            globalDelayTrackerMock.active.andCallFake(function(){
                return true;
            });

            inject(function ($controller, $rootScope, $q) {
                scope = $rootScope.$new();
                spyOn(scope, '$on').andCallThrough();
                controller = $controller('MainController', {$scope: scope});
                q = $q;
            });
        });

        it("should create delay promise", function(){
            expect(scope.delayed).toBeDefined();
        });

        describe("when modal is openned", function(){
            it("should aria hide background content", function(){

            });
        });

        describe("when modal is closed", function(){
            it("should aria hide background content", function(){

            });
        });

        describe("when global delay tracker is active", function(){
            beforeEach(function(){
                globalDelayTrackerMock.active.andCallFake(function(){
                    return true;
                });
            });

            it("should create delay promise", function(){
                expect(scope.delayed.then).toEqual(jasmine.any(Function));
            });
        });

        describe("when global delay tracker is in-active", function(){

            var handler;

            beforeEach(function(){
                globalDelayTrackerMock.active.andCallFake(function(){
                    return false;
                });
                handler = jasmine.createSpy('resolved');
                scope.delayed.then(handler);
                scope.$root.$digest();
            });

            xit("should resolve delay promise", function(){
                expect(handler).toHaveBeenCalledWith('finished');
            });
        });
    });
});